USE [SUSDB]
GO
-- Lehnt und lscht ersetzte Edge Updates ab. 29.08.2020

	Declare @Anzahl int

	Set @Anzahl = (Select Count([Updateid]) as Anz
	FROM 
		[SUSDB].[PUBLIC_VIEWS].[vUpdate]

	where 
		DefaultTitle like '%edge-Stable%x64%' 
		and Isdeclined = 0 
		AND [UpdateID] 
		NOT IN
			(Select TOP 1 [Updateid]
				FROM 
			[SUSDB].[PUBLIC_VIEWS].[vUpdate]
				where 
			DefaultTitle like '%edge-Stable%x64%' and Isdeclined = 0
				Order By SUBSTRING(DefaultTitle,
				CHARINDEX('(',DefaultTitle,1)+1, 
				LEN(DefaultTitle)
				-CHARINDEX('(',DefaultTitle,1)-1) desc
				)
	)

	print @Anzahl
	-- Anzahl der Versionen ausgeben, die abgelehnt und gelscht werden knnen.

	Declare @UpdateID1 uniqueidentifier

	IF @Anzahl = 0
		Begin
			Print '=0!'
			RETURN
		END
	IF ( @Anzahl > 0 )
		START:
			Begin

			-- Hier beginnt die eigentliche Schleife und Arbeit. :)
			While ( @Anzahl > 0 ) BEGIN
				SET @UpdateID1 = (
									Select 
										TOP 1 [Updateid]
									FROM 
										[SUSDB].[PUBLIC_VIEWS].[vUpdate]

									where 
										DefaultTitle like '%edge-Stable%x64%' and Isdeclined = 0 AND [UpdateID] NOT IN
										(Select 
											TOP 1 [Updateid]
										FROM 
											[SUSDB].[PUBLIC_VIEWS].[vUpdate]
										where 
											DefaultTitle like '%edge-Stable%x64%' and Isdeclined = 0
										Order By 
											SUBSTRING(DefaultTitle,
											CHARINDEX('(',DefaultTitle,1)+1, 
											LEN(DefaultTitle)
											-CHARINDEX('(',DefaultTitle,1)-1) desc
											)
										Order By 
											SUBSTRING(DefaultTitle,
											CHARINDEX('(',DefaultTitle,1)+1, 
											LEN(DefaultTitle)
											-CHARINDEX('(',DefaultTitle,1)-1) desc
									)
					-- Update ablehnen.	Die Stored Procedure spDeclineUpdate ist im Original bei jedem WSUS in der SUSDB dabei.
					EXEC [SUSDB].[dbo].[spDeclineUpdate] @UpdateID1;
					-- Update lschen. Die Stored Procedure spDeleteUpdateByUpdateID ist im Original bei jedem WSUS in der SUSDB dabei.
					EXEC [SUSDB].[dbo].[spDeleteUpdateByUpdateID] @UpdateID1;
					-- Von der Gesamt Anzahl abziehen.
					SET @Anzahl-=1
			END

			IF( @Anzahl > 0 )
				GOTO Start
			ELSE
				--Wenn es keine Edge Versionen zum Ablehnen gibt, wird die SP/das Script verlassen.
			RETURN
		END